﻿
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace Mdws2ORM
{
    public class GetParamBuilder
    {
        private static string defaultFlags;
        private static GetParam defaultParam;

        internal static string DefaultFlags
        {
            get
            {
                return defaultFlags;
            }
            set
            {
                defaultFlags = value;
                defaultParam = new GetParamBuilder().Build();
            }
        }

        public GetParamBuilder()
        {
            if (DefaultFlags == null)
                throw new InvalidOperationException("DefaultFlags must be set");
        }

        public static GetParam DefaultParam { get { return defaultParam; } }

        private string flags = DefaultFlags;

        public GetParamBuilder Flags(string value)
        {
            flags = value;
            return this;
        }

        public GetParam Build() { return new GetParam(flags); }
    }
}
